import { EditViewProps, EditViewState, MainView } from '@ibiz-core';

/**
 * 编辑视图
 * @export
 * @class ViewBase
 */
export class EditView extends MainView {
  /**
   * 视图状态
   */
  public declare viewState: EditViewState;

  /**
   * 使用加载功能模块
   * @param props 传入的props
   */
  public useLoad(props: EditViewProps){
    const { viewSubject } = this.viewState;
    onMounted(()=>{
      viewSubject.next({tag: 'form', action: "load", data: {}})
    })
  }

  /**
   * 安装视图所有功能模块的方法
   * @param props 传入的Props
   * @param [emit] 事件
   */
  public moduleInstall(props: EditViewProps, emit?: Function) {
    const superParams = super.moduleInstall(props, emit);
    this.useLoad(props);
    return {
      ...superParams,
      state: this.viewState,
    };
  }
}
